/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.LogoJMenuItem;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.dialog.comp.SpinnerCellEditor;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;

public class IndexedJTablePanel
extends JScrollPane {
    private int fMaxTableLine;
    private JTable fTable;
    private LogoJPopupMenu fPopupMenu;
    private JList fRowHeader;
    private JLabel fTopLeftConner;
    private Point fClickedPoint;
    private int lastClickedLine = -1;

    public IndexedJTablePanel(JTable jTable, int maxTableLine) {
        this.fMaxTableLine = maxTableLine;
        this.initialTable(jTable);
        DefaultListModel listModel = new DefaultListModel();
        this.fRowHeader = new JList(listModel);
        this.fRowHeader.addKeyListener(new RowHeaderKeyAdapter());
        RowHeaderMouseAdapter mouseAdapter = new RowHeaderMouseAdapter();
        this.fRowHeader.addMouseListener(mouseAdapter);
        this.fRowHeader.addMouseMotionListener(new RowHeaderMouseMotionAdapter());
        this.fRowHeader.setSelectionMode(2);
        this.fRowHeader.setFixedCellWidth(20);
        this.fRowHeader.setFixedCellHeight(this.fTable.getRowHeight() + this.fTable.getRowMargin() - 1);
        this.fRowHeader.setCellRenderer(new RowHeaderRenderer(this.fTable));
        this.fTopLeftConner = new JLabel(Language.getString("panel.tablePanel.ID", "ID"));
        this.fTopLeftConner.setHorizontalAlignment(0);
        this.setRowHeaderView(this.fRowHeader);
        this.setWheelScrollingEnabled(true);
        this.setViewportView(this.fTable);
        this.setCorner("UPPER_LEFT_CORNER", this.fTopLeftConner);
    }

    public void setRowHeight(int rowHeight) {
        this.fTable.setRowHeight(rowHeight);
        this.fRowHeader.setFixedCellHeight(rowHeight + this.fTable.getRowMargin() - 1);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.fTable.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    private void initialTable(JTable jTable) {
        this.fTable = jTable;
        this.fTable.setCellSelectionEnabled(true);
        this.fTable.getTableHeader().setReorderingAllowed(false);
        this.fTable.getSelectionModel().setSelectionMode(2);
        EnterKeyAction handleEnter = new EnterKeyAction();
        this.fTable.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "handleEnter");
        this.fTable.getActionMap().put("handleEnter", handleEnter);
        this.fTable.addKeyListener(new RowHeaderKeyAdapter());
        this.fTable.addKeyListener(new IndexJTableKeyAdapter());
        this.fTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                IndexedJTablePanel.this.fClickedPoint = e.getPoint();
                if (e.getButton() == 3) {
                    int rowNumber = IndexedJTablePanel.this.fTable.rowAtPoint(e.getPoint());
                    if (!IndexedJTablePanel.this.fTable.isRowSelected(rowNumber)) {
                        IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
                        IndexedJTablePanel.this.fTable.setRowSelectionInterval(rowNumber, rowNumber);
                    }
                    IndexedJTablePanel.this.getPopupMenu().show(IndexedJTablePanel.this.fTable, e.getX(), e.getY());
                    return;
                }
            }
        });
    }

    protected void insertBeforeCurrentRow(int selectedRow) {
        this.addRowIntoJTable(selectedRow, null);
        this.fTable.setRowSelectionInterval(selectedRow, selectedRow);
        this.fTable.setColumnSelectionInterval(0, this.fTable.getColumnCount() - 1);
        Rectangle rect = this.fTable.getCellRect(selectedRow, 0, true);
        this.fTable.scrollRectToVisible(rect);
    }

    protected void insertAfterCurrentRow(int selectedRow) {
        this.addRowIntoJTable(selectedRow + 1, null);
        this.fTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
        this.fTable.setColumnSelectionInterval(0, this.fTable.getColumnCount() - 1);
        Rectangle rect = this.fTable.getCellRect(selectedRow + 1, 0, true);
        this.fTable.scrollRectToVisible(rect);
    }

    private LogoJPopupMenu getPopupMenu() {
        if (this.fPopupMenu == null) {
            this.fPopupMenu = new LogoJPopupMenu();
            LogoJMenuItem insertItem = new LogoJMenuItem(Language.getString("ethernet.connectionConfigurePanel.insertRow", "Insert Row"));
            insertItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selectedRow = IndexedJTablePanel.this.fTable.rowAtPoint(IndexedJTablePanel.this.fPopupMenu.getPopUpLocation());
                    IndexedJTablePanel.this.insertBeforeCurrentRow(selectedRow);
                }
            });
            LogoJMenuItem deleteItem = new LogoJMenuItem(Language.getString("ethernet.connectionConfigurePanel.deleteRow", "Delete Row"));
            deleteItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IndexedJTablePanel.this.deleteSelectedRowsFromJTable();
                }
            });
            this.fPopupMenu.add(insertItem);
            this.fPopupMenu.add(deleteItem);
        }
        return this.fPopupMenu;
    }

    public void addRowIntoJTable(int row, Object[] data) {
        if (((DefaultTableModel)this.fTable.getModel()).getRowCount() >= this.fMaxTableLine) {
            new LogoError(Language.getString("dialog.table.reachMaxLine", "The number of lines must not exceed " + this.fMaxTableLine + ".", Integer.toString(this.fMaxTableLine))).display();
            return;
        }
        if (row < 0) {
            ((DefaultTableModel)this.fTable.getModel()).addRow(data);
        } else {
            ((DefaultTableModel)this.fTable.getModel()).insertRow(row, data);
        }
        JList headerList = (JList)this.getRowHeader().getView();
        ((DefaultListModel)headerList.getModel()).addElement(this.fTable.getRowCount());
    }

    public void deleteSelectedRowsFromJTable() {
        int firstRowNumber;
        this.fTable.removeEditor();
        int n = firstRowNumber = this.fTable.getSelectedRow() != -1 && this.fTable.getSelectedRow() != 0 ? this.fTable.getSelectedRow() - 1 : 0;
        while (this.fTable.getSelectedRow() != -1) {
            if (this.fTable.getEditingRow() == this.fTable.getSelectedRow()) {
                this.fTable.getCellEditor().stopCellEditing();
            }
            ((DefaultTableModel)this.fTable.getModel()).removeRow(this.fTable.getSelectedRow());
            if (this.fTable.getRowCount() == 0) {
                Object[] data = null;
                ((DefaultTableModel)this.fTable.getModel()).addRow(data);
                continue;
            }
            JList headerList = (JList)this.getRowHeader().getView();
            ((DefaultListModel)headerList.getModel()).removeElementAt(headerList.getModel().getSize() - 1);
        }
        this.fTable.setRowSelectionInterval(firstRowNumber, firstRowNumber);
    }

    public void deleteRow(int row) {
        ((DefaultTableModel)this.fTable.getModel()).removeRow(row);
        JList headerList = (JList)this.getRowHeader().getView();
        ((DefaultListModel)headerList.getModel()).removeElementAt(row);
    }

    public void setCellEditor(int columnIndex, TableCellEditor editor) {
        this.fTable.getColumnModel().getColumn(columnIndex).setCellEditor(editor);
    }

    public int getRowCount() {
        return this.fTable.getRowCount();
    }

    public JTable getTable() {
        return this.fTable;
    }

    public Point getClickedPoint() {
        return this.fClickedPoint;
    }

    class EnterKeyAction
    extends AbstractAction {
        EnterKeyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = IndexedJTablePanel.this.fTable.getSelectedRow();
            int selectedColumn = IndexedJTablePanel.this.fTable.getSelectedColumn();
            if (IndexedJTablePanel.this.fTable.getEditorComponent() != null) {
                IndexedJTablePanel.this.fTable.getCellEditor().stopCellEditing();
            }
            Rectangle rect = null;
            if (selectedRow == IndexedJTablePanel.this.fTable.getRowCount() - 1 && selectedColumn == IndexedJTablePanel.this.fTable.getColumnCount() - 1) {
                if (IndexedJTablePanel.this.fTable.getRowCount() < IndexedJTablePanel.this.fMaxTableLine) {
                    IndexedJTablePanel.this.insertAfterCurrentRow(selectedRow);
                    IndexedJTablePanel.this.fTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                    IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, 0);
                    rect = IndexedJTablePanel.this.fTable.getCellRect(selectedRow + 1, 0, true);
                } else {
                    IndexedJTablePanel.this.fTable.setRowSelectionInterval(0, 0);
                    IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, 0);
                    rect = IndexedJTablePanel.this.fTable.getCellRect(0, 0, true);
                }
            } else if (selectedColumn < IndexedJTablePanel.this.fTable.getColumnCount() - 1) {
                IndexedJTablePanel.this.fTable.setColumnSelectionInterval(selectedColumn + 1, selectedColumn + 1);
                IndexedJTablePanel.this.fTable.setRowSelectionInterval(selectedRow, selectedRow);
                rect = IndexedJTablePanel.this.fTable.getCellRect(selectedRow, selectedColumn + 1, true);
            } else {
                IndexedJTablePanel.this.fTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, 0);
                rect = IndexedJTablePanel.this.fTable.getCellRect(selectedRow + 1, 0, true);
            }
            if (rect != null) {
                IndexedJTablePanel.this.fTable.scrollRectToVisible(rect);
            }
        }
    }

    class IndexJTableKeyAdapter
    extends KeyAdapter {
        IndexJTableKeyAdapter() {
        }

        public void keyTyped(KeyEvent e) {
            if (Character.isDigit(e.getKeyChar())) {
                int column = IndexedJTablePanel.this.fTable.getSelectedColumn();
                int row = IndexedJTablePanel.this.fTable.getSelectedRow();
                TableCellEditor cellEditor = IndexedJTablePanel.this.fTable.getCellEditor(row, column);
                if (cellEditor instanceof SpinnerCellEditor && !((SpinnerCellEditor)cellEditor).getComponent().hasFocus()) {
                    int numberKey = Integer.valueOf(String.valueOf(e.getKeyChar()));
                    ((SpinnerCellEditor)cellEditor).getComponent().setValue(numberKey);
                    ((SpinnerCellEditor)cellEditor).getComponent().requestFocus();
                }
            }
        }
    }

    class RowHeaderKeyAdapter
    extends KeyAdapter {
        RowHeaderKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                if (IndexedJTablePanel.this.fTable.getSelectedColumnCount() == 4) {
                    IndexedJTablePanel.this.deleteSelectedRowsFromJTable();
                }
            } else if (e.getKeyCode() == 155 && IndexedJTablePanel.this.fTable.getRowCount() < IndexedJTablePanel.this.fMaxTableLine) {
                int selectedRow = IndexedJTablePanel.this.fTable.getSelectedRow();
                IndexedJTablePanel.this.insertBeforeCurrentRow(selectedRow);
            }
            super.keyPressed(e);
        }
    }

    class RowHeaderMouseMotionAdapter
    extends MouseMotionAdapter {
        RowHeaderMouseMotionAdapter() {
        }

        public void mouseDragged(MouseEvent e) {
            int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
            int rowNumber = IndexedJTablePanel.this.fTable.rowAtPoint(e.getPoint());
            if (index < 0 || rowNumber < 0 || rowNumber >= IndexedJTablePanel.this.fTable.getRowCount()) {
                return;
            }
            IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
            IndexedJTablePanel.this.fTable.setRowSelectionInterval(IndexedJTablePanel.this.lastClickedLine, rowNumber);
        }
    }

    class RowHeaderMouseAdapter
    extends MouseAdapter {
        RowHeaderMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            int rowNumber = Integer.valueOf(((JList)e.getSource()).getModel().getElementAt(index).toString()) - 1;
            if (e.getButton() == 3) {
                if (!IndexedJTablePanel.this.fTable.isRowSelected(rowNumber)) {
                    IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
                    IndexedJTablePanel.this.fTable.setRowSelectionInterval(rowNumber, rowNumber);
                }
                IndexedJTablePanel.this.getPopupMenu().show(IndexedJTablePanel.this.fTable, e.getX(), e.getY());
            } else if (e.getModifiersEx() == 64) {
                IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
                IndexedJTablePanel.this.fTable.setRowSelectionInterval(IndexedJTablePanel.this.lastClickedLine, rowNumber);
            } else if (e.getModifiersEx() == 128) {
                if (IndexedJTablePanel.this.fTable.isRowSelected(rowNumber)) {
                    IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
                    IndexedJTablePanel.this.fTable.removeRowSelectionInterval(rowNumber, rowNumber);
                } else {
                    IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
                    IndexedJTablePanel.this.fTable.addRowSelectionInterval(rowNumber, rowNumber);
                }
                IndexedJTablePanel.this.lastClickedLine = IndexedJTablePanel.this.fTable.rowAtPoint(e.getPoint());
            } else {
                IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
                IndexedJTablePanel.this.fTable.setRowSelectionInterval(rowNumber, rowNumber);
                IndexedJTablePanel.this.lastClickedLine = IndexedJTablePanel.this.fTable.rowAtPoint(e.getPoint());
            }
        }

        public void mousePressed(MouseEvent e) {
            int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            if (e.getModifiersEx() == 1088) {
                return;
            }
            IndexedJTablePanel.this.lastClickedLine = IndexedJTablePanel.this.fTable.rowAtPoint(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
            int rowNumber = IndexedJTablePanel.this.fTable.rowAtPoint(e.getPoint());
            if (index < 0 || rowNumber < -1 || rowNumber >= IndexedJTablePanel.this.fTable.getRowCount()) {
                return;
            }
            IndexedJTablePanel.this.fTable.setColumnSelectionInterval(0, IndexedJTablePanel.this.fTable.getColumnCount() - 1);
            IndexedJTablePanel.this.fTable.setRowSelectionInterval(IndexedJTablePanel.this.lastClickedLine, rowNumber);
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

